//
//  CRUndoProxy.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 4/13/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Undo manager, takes care of all undo stuff
// Doesn't retain Object neither UndoManager
//////////////////////////////////////////////////////////////////////
@interface CRUndoProxy : NSObject
{
	id<CRUndoable> __strong object;
}

@property (strong) id<CRUndoable> object;
@property (assign) NSUndoManager* undoManager;

- (id)initWithManager:(NSUndoManager *)aManager;
- (id)initWithRoot:(id)root manager:(NSUndoManager *)manager;

- (void)observeObject;
- (void)stopObservingObject;

@end